; 5.9
; ISBNԍoŎЋL𔲂o
(defun publisher (isbn)
  (floor (- isbn (* 1000000000 (floor isbn 1000000000))) 100000) )

; ISBNԍ珑L𔲂o
(defun book (isbn)
  (floor (- isbn (* 100000 (floor isbn 100000))) 10) )

; ISBNԍ`FbNfBWbgvZ
(defun check-digit (isbn)
  (check-digit2 (number2list (floor (/ isbn 10))) 1 0) )
(defun check-digit2 (nlist weight ret)
  (if (null nlist)
    (mod (- 10 (mod ret 10)) 10) 
    (check-digit2 (cdr nlist) (if (= weight 1) 3 1) (+ ret (* weight (car nlist)))) ))

; 1̃Xgɕϊ
(defun number2list (n &optional ret)
  (if (< n 10)
     (cons n ret)
     (number2list (floor n 10) (cons (mod n 10) ret)) ))

; ͂ꂽoŎЂoŎЃXgɂ邩ǂ̃`FbN֐
(defun check-publisher (publisher publisher-list)
  (assoc publisher publisher-list) )

; ͂ꂽ҂҃Xgɂ邩ǂ̃`FbN֐
(defun check-author (author author-list)
  (assoc author author-list) )

; ISBNԍ̏oŎЂAoŎЃXgɂAꂪ͂ꂽoŎЂƓǂ
(defun check-isbn-publisher (isbn publisher publisher-list)
  (eq publisher (car (raasoc (publisher isbn) publisher-list))) )
 
; ISBNԍ̃`FbNfBWbgǂ𔻒肷֐
(defun check-check-digit (isbn)
  (eq (mod isbn 10) (check-digit isbn)) )

; Ѓf[^璘҂̐擪o֐
(defun author-index (book-alist)
  (let ((author-list (cdr (assoc 'author book-alist))))
    (if (null author-list)
      nil
      (aref (car author-list) 0) )))

; ҊKwXgւ̕ϊ֐
(defun author-index-list (book-alist book-layer-list)
  (let ((index (author-index book-alist)))
    (let ((alists (assoc index book-layer-list)))
      (if (null alists)
        (cons (cons index (list book-alist)) book-layer-list)
        (cons (cons index (cons book-alist (cdr alists))) book-layer-list) ))))

; ҊKwXg璘҂ƃ^CgŏЌ֐
(defun search-book (author title book-layer-list)
  (let ((char (aref author 0)))
    (let ((alist (cdr (assoc char book-layer-list))))
      (search-book2 author title alist) )))

(defun search-book2 (author title alist)
  (if (null alist)
    nil
    (if (and (equal (car (cdr (assoc 'author (car alist)))) author) 
           (equal (cdr (assoc 'title (car alist))) title) )
      (car alist)
      (search-book2 author title (cdr alist)) )))

;;; test
(defun test (tests)
  (dolist (test tests)
    (print test)
    (terpri)(princ "---->")
    (print (eval test)) 
    (terpri) ))

(setf tests '(

  (author-index 
      '((isbn . 9784000100014) (jan . 1923055012349) (author . ("GOMI Hiroshi"))
       (title . "Functional Programming in Lisp") (category . computer) 
       (publisher . a-press) (date .26-Oct-2016) (price . 15.75) ))

  (setf book-layer-list
    (author-index-list
      '((isbn . 9784000100014) (jan . 1923055012349) (author . ("GOMI Hiroshi"))
       (title . "Functional Programming in Lisp") (category . computer) 
       (publisher . a-press) (date . 26-Oct-2016) (price . 15.75) )
      () ))

))

(test tests)

