; 5.9
; Lisp ̍\̓vO
; S̍\
(defun expression (expr)
   (if (symbolp expr) (symbol-expr expr)
      (if (numberp expr) (number-expr expr) 
         (if (function-application-p expr) (function-application (car expr) (cdr expr))
            (if (my-special-form-p expr) (special-form-expr expr)
               (list 'error 'no-expression expr) )))))

; ֐KpH
(defun function-application-p (expr)
   (and (listp expr)
        (or 
          (and (symbolp (car expr))
               (not (member (car expr) '(defun if quote function lambda))) )
          (lambda-expression-p (car expr)) )))

; _H
(defun lambda-expression-p (expr)
   (and (listp expr) (eq (car expr) 'lambda) (argumentsp (cadr expr) nil)) )

; 񂩁H
(defun argumentsp (expr lap)
  (cons 'arguments (argumentsp2 expr lap)) )
(defun argumentsp2 (expr lap)
  (if (null expr)
    lap
    (if (or (not (listp expr)) (not (symbolp (car expr))))
       (append lap (list (list 'error 'arguments expr))) 
       (argumentsp2 (cdr expr) (append lap (list (list 'symbol (car expr))))) ))) 

; `H
(defun my-special-form-p (expr)
  (and (listp expr) (member (car expr) '(defun if quote function lambda))) )

; V{̂Ƃ
(defun symbol-expr (expr) (list 'symbol expr))

; ̂Ƃ
(defun number-expr (expr) (list 'number expr))

; ֐Kp̂Ƃ
(defun function-application (fun expr)
  (cons 'function-name (cons (list 'symbol fun)(expressions expr nil))) )

; ŜƂ
(defun expressions (expr lap)
  (if (null expr)
     lap
     (if (atom expr) 
        (append lap (list (list 'error 'arguments expr)))
        (expressions (cdr expr) (append lap (list (expression (car expr))))) )))

; `̂Ƃ
(defun special-form-expr (expr)
  (if (eq (car expr) 'defun) (defun-form (cdr expr))
    (if (eq (car expr) 'if) (if-form (cdr expr))
       (if (eq (car expr) 'quote) (quote-form (cdr expr))
          (if (eq (car expr) 'function) (function-form (cdr expr))
             (if (eq (car expr) 'lambda) (lambda-form (cdr expr))
                (list 'error 'no-special-form expr) )))))) 

; defun ̂Ƃ
(defun defun-form (expr)
  (append 
     (if (symbolp (car expr)) (list 'defun (list 'symbol (car expr))) (list 'error 'defun expr))
       (list (argumentsp (cadr expr) nil))
       (expressions (cddr expr) nil) ))

; if ̂Ƃ
(defun if-form (expr)
  (list 'if (expression (car expr)) 
       (expression (cadr expr)) 
       (or (null (cddr expr)) (expression (caddr expr))) ))	

; function ̂Ƃ
(defun function-form (expr) 
  (if (symbolp (car expr)) (list 'function-function (list 'symbol (car expr)))))

; _̂Ƃ
(defun lambda-form (expr) 
  (append (list 'lambda-expr (argumentsp (car expr) nil)) (expressions (cdr expr) nil)) )

; quote ̂Ƃ
(defun quote-form (expr)
  (if (cdr expr)
      (list 'error 'quote expr)
      (if (symbolp (car expr)) (list 'quote-symbol (symbol-expr (car expr)))
         (if (numberp (car expr)) (list 'quote-symbol (number-expr (car expr)))
             (if (listp (car expr)) (list 'quote-symbol (list 'list (car expr)))
                 (list 'error 'quote expr) )))))

; argumentsp2 ̍
(defun argumentsp2 (expr lap)
  (if (null expr)
    (reverse lap)
    (if (or (not (listp expr)) (not (symbolp (car expr))))
       (reverse (cons (list 'error 'arguments expr) lap))
       (argumentsp2 (cdr expr) (cons (list 'symbol (car expr)) lap)) )))

; expressions ̍
(defun expressions (expr lap)
  (if (null expr)
     (reverse lap)
     (if (atom expr) 
        (reverse (cons (list 'error 'arguments expr) lap))
        (expressions (cdr expr) (cons (expression (car expr)) lap)) )))

;;; test
(defun test (tests)
  (dolist (test tests)
    (print test)
    (terpri)(princ "---->")
    (print (eval test)) 
    (terpri) ))

(setf tests '(

(expression '(defun fact (n) (if (<= n 1) 1 (* n (fact (- n 1))))))

))

(test tests)

