; 5.3
; nNB[vO
(defun nqueen (n)
  (nqueen2 n 1 nil) )
(defun nqueen2 (n y board)
  (if (> y n)
      nil
      (if (or (member y board) (diagonal 1 y board))
          (nqueen2 n (+ y 1) board)
          (append
             (if (= (length board) (- n 1))
                 (list (cons y board))
                 (nqueen2 n 1 (cons y board)) )
             (nqueen2 n (+ y 1) board) ))))
(defun diagonal (x queen board)
  (if (null board)
      nil
      (if (= (abs (- (car board) queen)) x)
          t
          (diagonal (+ x 1) queen (cdr board)) )))

; nCubhł nNB[vO
; nqueen
(defun inqueen (n)
  (inqueen2 n 1 nil) )
; nqueen2
(defun inqueen2 (n y board)
  (if (> y n)
      nil
      (if (or (member y board) (idiagonal 1 y board))
          (inqueen2 n (+ y 1) board)
          (append
             (if (= (length board) (- n 1))
                 (list (cons y board))
                 (inqueen2 n 1 (cons y board)) )
             (inqueen2 n (+ y 1) board) ))))
; diagonal
(defun idiagonal (x queen board)
  (let ((i x))
    (dolist (e board nil)
       (if (= (abs (- e queen)) i) (return-from nil t) )
       (setf i (+ i 1)) )))

; c[go[X
(defun traverse (tree fun)
  (if (null tree)
      nil
      (if (atom (car tree))
          (cons (funcall fun (car tree)) (traverse (cdr tree) fun))
          (cons (traverse (car tree) fun) (traverse (cdr tree) fun)) )))

; ̓c[tbgȃXgɂgo[X֐
(defun flat-traverse (tree fun) 
  (reverse (flat-traverse2 tree fun nil)) )
(defun flat-traverse2 (tree fun ret)
  (if (null tree)
      ret
      (if (atom (car tree))
          (flat-traverse2 (cdr tree) fun (cons (funcall fun (car tree)) ret))
          (flat-traverse2 (cdr tree) fun (flat-traverse2 (car tree) fun ret)) )))

; Vvȑ҂s̎
; enq
(defun enq0 (e queue) (cons e queue))
; deq
(defun deq0 (queue) (reverse (cdr (reverse queue))))
; head
(defun head0 (queue) (car (reverse queue)))

; 2{̃Xgɂ҂s̎
(defun enq (e queue)
   (if (null (car queue)) 
       (cons (cons e (car queue)) (cdr queue))
       (cons (car queue) (cons e (cdr queue))) ))
(defun deq (queue)
   (if (null (cdr (car queue))) 
       (cons (reverse (cdr queue)) nil)
       (cons (cdr (car queue)) (cdr queue)) ))
(defun head (queue)
   (car (car queue)) )

;;; test
(defun test (tests)
  (dolist (test tests)
    (print test)
    (terpri)(princ "---->")
    (print (eval test)) 
    (terpri) ))

(setf tests '(

(nqueen 8)
(length (nqueen 8))
(inqueen 8)
(length (inqueen 8))


(traverse '(1 (2 3) (4 5)) (lambda (x) (+ x 1)))
(flat-traverse '(1 (2 3) (4 5)) (lambda (x) (+ x 1)))
(setf document 
    '("document" ("chapter 1" 
                   ("section 1" "sentence 1" "sentence 2")
                   ("section 2" "sentence 1" "sentence 2" "sentence 3") )
                 ("chapter 2" 
                     ("section 1" "sentence 1" "sentence 2" "sentence 3" "sentence 4")
                     ("section 2" "sentence 1" "sentence 2" "sentence 3") )))
(flat-traverse document (lambda (x) (length x)) )
(flat-traverse document (lambda (x) x) )

(setf q0 (enq0 1 ()))
(setf q0 (enq0 2 q0))
(setf q0 (enq0 3 q0))
(setf q0 (deq0 q0))
(setf q0 (enq0 4 q0))
(setf q0 (enq0 5 q0))
(setf q0 (deq0 q0))
(setf q0 (deq0 q0))
(setf q0 (deq0 q0))

(setf q (enq 1 '(())))
(setf q (enq 2 q))
(setf q (enq 3 q))
(setf q (deq q))
(setf q (enq 4 q))
(setf q (enq 5 q))
(setf q (deq q))
(setf q (deq q))
(setf q (deq q))

))

(test tests)
