; 5.2
; S(1K֐)
(defun my-find1 (key list)
   (if (null list)
       nil
       (append 
          (if (eq key (car list))
              (list (car list)) )
          (my-find1 key (cdr list)) )))

; S(2K֐)
(defun my-find (fun key list)
   (if (null list)
       nil
       (append 
          (if (funcall fun key (car list))
              (list (car list)) )
          (my-find fun key (cdr list)) )))

; NCbN\[gi2K֐Łj
(defun qsort (fun list)
   (if (null list)
       list
       (qsort2 fun (car list) (cdr list) nil nil) ))
(defun qsort2 (fun p list left right)
   (if (null list)
       (append (qsort fun left) (cons p (qsort fun right)))
       (if (funcall fun (car list) p)
           (qsort2 fun p (cdr list) (cons (car list) left) right)
           (qsort2 fun p (cdr list) left (cons (car list) right)) )))

; NCbN\[gi2֐)
; qsort
(defun qsort-2 (place comp list)
   (if (null list)
       list
       (qsort2-2 place comp (car list) (cdr list) nil nil) ))
; qsort2
(defun qsort2-2 (place comp p list left right)
   (if (null list)
       (append (qsort-2 place comp left) (cons p (qsort-2 place comp right)))
       (if (funcall comp (funcall place (car list)) (funcall place p))
           (qsort2-2 place comp p (cdr list) (cons (car list) left) right)
           (qsort2-2 place comp p (cdr list) left (cons (car list) right)) )))

;;; test
(defun test (tests)
  (dolist (test tests)
    (print test)
    (terpri)(princ "---->")
    (print (eval test)) 
    (terpri) ))

(setf tests '(

(my-find1 3 '(3 1 2 3 4 3 5))
(my-find #'= 3 '(3 1 2 3 4 3 5))

(qsort #'< '(2 1 3 5 4))
(qsort #'> '(2 1 3 5 4))
(qsort (lambda (x y) (< (car x) (car y))) '((2 . 20) (1 . 10) (3 . 30) (5 . 50) (4 . 40)))

(qsort-2 (lambda (x) x) #'< '(2 1 3 5 4))
(qsort-2 (lambda (x) x) #'> '(2 1 3 5 4))
(qsort-2 #'car #'< '((2 . 20) (1 . 10) (3 . 30) (5 . 50) (4 . 40)))

))

(test tests)
