; 5.1
; NCbN\[g@r֐Œ
; qsort
(defun qsort-1 (list)
  (if (null list)
      list
      (qsort2-1  (car list) (cdr list) nil nil) ))
; qsort2
(defun qsort2-1 (p list left right)
  (if (null list)
     (append (qsort-1 left) (cons p (qsort-1 right)))
     (if (< (car list) p)
         (qsort2-1 p (cdr list) (cons (car list) left) right)
         (qsort2-1 p (cdr list) left (cons (car list) right)) )))

; nCubhŃNCbN\[g@r֐Œ
(defun iqsort (list)
   (if (null list)
       list
       (let ((p (car list))
             (left nil)
             (right nil))
          (dolist (e (cdr list))
             (if (< e p)
                 (push e left)
                 (push e right) ))
          (append (iqsort left) (list p) (iqsort right)) )))

; nmC̓
(defun hanoi (n &optional (from 'from) (to 'to) (other 'other))
    (if (= n 1) 
        (cons (cons from to) nil)
        (append
	   (hanoi (- n 1) from other to)
           (hanoi 1 from to other)
           (hanoi (- n 1) other to from) )))

; 4{̃nmC̓
(defun hanoi4 (n from to other1 other2)
  (if (< n 3)
      (hanoi n from to other1)
      (if (= n 3)
          (append (list (cons from other1)) (hanoi3 2 from to other2) (list (cons other1 to)))
          (append (hanoi4 (- n 3) from other1 other2 to)
                  (hanoi 3 from to other2)
                  (hanoi4 (- n 3) other1 to other2 from) ))))

;;; test
(defun test (tests)
  (dolist (test tests)
    (print test)
    (terpri)(princ "---->")
    (print (eval test)) 
    (terpri) ))

(setf tests '(

(qsort-1 '(2 1 3 5 4))

(iqsort '(2 1 3 5 4))
(hanoi 2)
(hanoi 3)
(hanoi4 4 'from 'to 'other1 'other2)
(hanoi4 5 'from 'to 'other1 'other2)

))

(test tests)
